hcD      D   q,  ]d5	 M DIVIDE BY 0                              

THIS IS THE FIRST BIOS INTERRUPT. THE
BIOS INTERRUPTS GO UP TO INT 1F

DOS INTs START AT 20h

2 E % M $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 00 	W N SINGLE STEP                              

USED IF YOU'RE WRITING A DEGUGGER.
2 N % N $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 01 	 O NONMASKABLE INTERRUPT                    

A HARDWARE INT THAT IS ALWAYS RUN WHEN
CALLED. YOU CAN'T BLOCK IT BY USING 
STI/CLI.
2 O % O $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 02 	 P BREAKPOINT                             

IF YOU WANT A BRKPOINT JUST PUT INT 3
IN THE DEBUG SCRIPT FILE, THE CODE WILL
RUN UP TO THE INT 3 THEN RETURN CONTROL 
TO DEBUG2 P % P $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 03 	3 Q OVERFLOW                                 

2 Q % Q $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 04 	7 R PRINT SCREEN                                 

2 R % R $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 05 	1 S RESERVED                                 
4 S % S $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 06/7 	 T TIME OF DAY                                  

USED TO UPDATE THE TIME OF DAY 18.2 TIMES
A SEC.

THIS INT CALLS INT 1C

2 T % T $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 08 	W U KEYBOARD                                 

MAY BE INTERCEPTED BY TSR PROGRAMS
2 U % U $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 09 	1 V RESERVED                                 
2 V % V $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 0A 	 X SET CURSOR TYPE                                                           
INPUT
AH=1
CH=CURSOR START LINE
CL=CURSOR END LINE

OUT
NEW CURSOR

5 X % X $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 10,01 	u  ASCII adjust after addition.                                 
Adjusts the result in AL, after two ASCII
digits have been added together.

If AL > 9. the high digit of the result 
is placed in AH, anf the Carry and Aux 
Carry flags are set.

SAMPLE CODE
MOV AH,07
MOV AL,08
ADD AL,AH ;15D IN AL
SUB AH,AH ;AH=0
AAA
OR AX,3030 ;CONVERT DIGITS TO ASCII

;   %   ) $ $ + - / 1 3 $ $ $ $ $ $ $ $  AAA ? ? ? * ? * 	 ASCII adjust before division                                 

Converts unpacked BCD digits in AH and AL
to a single binary value in preparation
for the DIV instruction.

SAMPLE CODE

MOV AH,'7'
MOV AL,'6'
AND AX,0F0F ;ASCII TO BCD 0706
AAD         ;CONVERT TO 004C

;  %  ) $ $ + - / 1 3 $ $ $ $ $ $ $ $  AAD ? * * ? * ? 	o ASCII adjust after subtraction                                 

Adjusts the results in AX after a subtrac-
tion operation. 

If AL > 9, AAS decrements AH and sets the 
Carry and the Aux Carry flags.

SAMPLE CODE

MOV AH,01 ; AH=BCD 1
MOV AL,04 ; AL=BCD 4
MOV BL,07
SUB AL,BL ; AL <-AL-BL (14-7)
AAS       ; AX=0007 BCD
OR AX 3030; ASCII 3037

;  %  ) $ $ + - / 1 3 $ $ $ $ $ $ $ $  AAS ? * * * * * 	 Add with Carry                                 

Adds the source and destination operands
and adds the contents of the Carry flag
to the sum, which is stored in the 
destination

SAMPLE CODE

DATASEG
VAR DD 01FFFIEH   ; 131070 DEC
CODESEG       
MOV AX,5          ; VALUE TO ADD
MOV BX,OFFSET VAR ; ADDR VAR
ADD [WORD BX],AX  ; ADD LOW-ORDER WORD
ADC [WORD BX+2],0 ; ADD IN CARRY (VAR=131075)

q  %  ) $ $ + - / 1 3 5 = E M W a $ $  ADC ? * * * * * reg,reg mem,reg reg,mem reg,immed mem,immed acc,immed 	  Add without carry                        
Adds the source operand to a destination
operand and stores the sum in the destina-
tion

SAMPLE CODE

MOV AX,45
MOV BX,1000
ADD AX,BX   ; AX=1045

q  %  ) $ $ + - / 1 3 5 = E M W a $ $  ADD * * * * * * reg,reg mem,reg reg,mem reg,immed mem,immed acc,immed 	| Call a procedure:                                 

Pushes the location of the next instruc-
tion on the stack and transfers to the 
destination location. 

If the procedure is near (in the same 
segment), only the offset of the next 
instruction is pushed; otherwise, both 
the segment and the offset are pushed

SAMPLE CODE

SEE RING OR RING2 IN DBUG100.GDB
S  %  $ $ $ $ $ $ $ $ * 4 = A G $ $ $  CALL nearlabel farlabel reg mem16 mem32 	H	 Convert byte to word:                                 

Extends the sign bit in AL, throughout 
the AH register.

SAMPLE CODE

MOV AL,-1
CBW       ; EXTEND AL TO AX
            AX= -1

COPIES THE MSD OF AL TO ALL BITS IN
AH THUS SETTING AH TO 0FF IF AL WAS
NEGATIVE OR SETTING AH TO 00H IF AL
WAS POSITIVE.
/ 	 % 	 $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  CBW 	\ 
 Clear carry flag:                                 

Clears the carry flag to zero.
1 
 % 
 $ $ $ $ $ $ $ ) $ $ $ $ $ $ $ $  CLC 0 	  Clear direction flag:                                 

Clears the Direction flag to zero. 
String primitive instructions will auto- 
matically increment SI and DI.

1  %  $ ) $ $ $ $ $ $ $ $ $ $ $ $ $ $  CLD 0 	  Clear interrupt flag:                                 

Clears the Interrupt flag to zero. This 
disables masking hardware interrupts 
until an STI instruction is executed.

1  %  $ $ ) $ $ $ $ $ $ $ $ $ $ $ $ $  CLI 0 	 
 Complement carry flag:                                 

Toggles the current value of the Carry 
flag. A 0 is changed to a 1, and vice 
versa.

1 
 % 
 $ $ $ $ $ $ $ ) $ $ $ $ $ $ $ $  CMC * 	 Also CMPSB,CMPSW                                  
Compare strings addressed by ES:DI. 

Carries out an implied subtration of the 
destination from the source. SI and DI 
are incremented if the Direction flag is 
clear, or they are decremented if the 
flag is set. 

CMPSB compares byte operands, and 
CMPSW compares word operands.

CMPS source,dest
CMPS segreg:source,ES:dest
F  %  * $ $ , . 0 2 4 6 $ $ $ $ $ $ $  CMPS * * * * * * see right 	  Convert word to doubleword:                                 

Extends the sign bit in AX into the DX 
register. This is usually done in prepa- 
ration for a signed division (IDIV) op- 
eration.

/  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  CWD 	  Decimal adjust after addition:                                 

Adjusts the binary sum in AL, after 2 
packed BCD values have been added. 
Converts the sum tto two BCD digits in 
AL.

;  %  ) $ $ + - / 1 3 $ $ $ $ $ $ $ $  DAA ? * * * * * 	  Decimal adjust after subtraction:                                 

Converts the binary result of a subtrac- 
tion operation to 2 packed BCD digits in 
AL.

;  %  ) $ $ + - / 1 3 $ $ $ $ $ $ $ $  DAS ? * * * * * 	  Decrement:                                 

Subtracts 1 from a byte or word operand. 
Does not affect the Carry flag.

A  %  ) $ $ + - / 1 $ 3 7 $ $ $ $ $ $  DEC * * * * * reg mem 	J Divide, unsigned:                                 

Performs either 8 or 16-bit integer 
division. If the divisor is 8 bits, the 
dividend is AX, the quotient is AL< and 
the remainder is AH.

If the divisor is 16-bits, the dividend 
is DX:AX, the quotient is AX and the 
remainder is DX.
Divide, unsigned:



C  %  ) $ $ + - / 1 3 5 9 $ $ $ $ $ $  DIV ? ? ? ? ? ? reg mem 	$ Escape:                                 

Provides an instruction and an optional 
operand to a coprocessor.

The first operand specifies the bits of 
the coprocessor instruction, and the 
second operand is a register or memory 
operand that will be used by the 
processor.

C  %  $ $ $ $ $ $ $ $ ) 3 $ $ $ $ $ $  ESC immed,reg immed,mem 	  Halt:                                 

Stops the CPU until a hardware interrupt 
occurs. Note that the Interrupt flag 
must be set by STI, in order for a 
hardware interrupt to occur.

/  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  HLT 	 Signed Integer Division:                                 

Performs a signed division operation on 
either DX:AX or AX.

If the divisor is 8 bits, the dividend 
is AX, the quotient is AL, and the 
remainder is AH. If the divisor is 16 
bits,, the dividend is DX:AX, the 
quotient is AX, and the remainder is DX.

Usually the IDIV operation is prefaced 
by either CBW (convert byte to word) or 
CWD (convert word to doubleword) to 
sign-extend the dividend.

D  %  * $ $ , . 0 2 4 6 : $ $ $ $ $ $  IDIV ? ? ? ? ? ? reg mem 	 Signed integer multiply:                                 

Performs a signed integer multiplication 
on either AL or AX.

If the multiplier is 8 bits, the multi- 
plicand is AL and the product is AX; 
otherwise, the multiplicand is AX and 
the product is DX:AX. The Carry and 
Overflow flags are set if a 16-bit 
product extends into AH or a 32-bit 
product extends into DX.

D  %  * $ $ , . 0 2 4 6 : $ $ $ $ $ $  IMUL * ? ? ? ? * reg mem 	  Input from port:                                 

Inputs a byte or word from a port into 
AL or AX. The source operand is a port 
address, express as either an 8 bit 
constant or a 16-bit address in DX

?  %  $ $ $ $ $ $ $ $ ( 2 $ $ $ $ $ $  IN acc,immed acc,DX 	  Increment:                                 

Adds 1 to a register or memory operand, 
but does not affect the Carry flag.

A  %  ) $ $ + - / 1 $ 3 7 $ $ $ $ $ $  INC * * * * * reg mem 	Y Interrupt:                                 

Generates a software interrupt, which in 
turn calls a routine in the ROM BIOS or 
RAM.

Clears the Interrupt flag and trap flag; 
pushes the fags, CS, and IP on the stack 
before branching to the interrupt 
routine. A special form, the INT 3 
instruction, generates a breakpoint.

=  %  $ $ ) $ $ $ $ $ + 1 $ $ $ $ $ $  INT 0 immed INT 3 	  Interrupt on overflow:                                 

Generates internal CPU Interrupt 4 if 
the Overflow flag is set. No action is 
taken by DOS if INT 4 is called, but a 
user-written routine may be substituted 
instead.

4  %  $ $ * , $ $ $ $ $ $ $ $ $ $ $ $  INTO * * 	  Interrupt return:                                 

Returns from an interrupt handling 
routine. Pops the stack into IP, CS and 
the flags.

@  %  * , . 0 2 4 6 8 $ $ $ $ $ $ $ $  IRET * * * * * * * * 	  Jump if CX is zero:                                 

Jump to a short label if the CX register 
is zero.

The short label must be in the range
-128 to +127 bytes from the next 
instruction.

;  %  $ $ $ $ $ $ $ $ * $ $ $ $ $ $ $  JCXZ shortlabel 	   Jump unconditionally to a label:                                 

The label may be short (-128 to +127 
bytes), near(current segment), or far 
(different segment)

_   %   $ $ $ $ $ $ $ $ ) 4 > G M S $ $  JMP shortlabel nearlabel farlabel reg16 mem16 mem32 	 ! Load flags into AH:                                 

The lowest 8 bits of the flags are 
transferred, but not the Trap, Interrupt, 
Overflow, and Direction flags

0 ! % ! $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  LAHF 	 " Load register and DS:                                 

Loads the contents of a doubleword 
memory operand into DS and the specified 
register.

9 " % " $ $ $ $ $ $ $ $ ) $ $ $ $ $ $ $  LDS reg,mem32 	 E Load effective address:                                 

Calculates and loads the 16-bit 
effective address of a memory operand.

7 F % E $ $ $ $ $ $ $ $ ) $ $ $ $ $ $ $  LEA reg,mem 	 F Load register and ES:                                 

Loads the contents of doubleword memory 
operand into ES and the specified 
register.

9 G % F $ $ $ $ $ $ $ $ ) $ $ $ $ $ $ $  LES reg,mem32 	G Lock the system bus:                                 

Prevents other processors from executing 
during the next instruction.

This instruction is used when another 
processor might modify a memory operand 
that is currently being accessed by the 
CPU.

< H % G $ $ $ $ $ $ $ $ * $ $ $ $ $ $ $  LOCK instruction 	rH Also LODSB,LODSW: Load string:                                 

Loads a memory byte or word addressed by 
DS:SI into the accumulator.

If LODS is used, the memory operand must 
be specified. LODSB loads a byte into 
AL, and LODSW loads a word into AX. If 
the Direction flag is clear, SI is 
automatically incremented; otherwise, SI 
is decremented.

? I % H $ $ $ $ $ $ $ $ * . $ $ $ $ $ $  LODS mem segreg:mem 	 I Loop:                                    
Decrements CX and jumps to a short label                  if CX is greater than zero.

The short label must be in the range
-128 to +127 from the next instruction.


; J % I $ $ $ $ $ $ $ $ * $ $ $ $ $ $ $  LOOP shortlabel 	 J Also LOOPZ:                                  

Loop if equal(zero):

Decrements CX and jumps to a short label 
if CX > 0 and the Zero flag is set.


< K % J $ $ $ $ $ $ $ $ + $ $ $ $ $ $ $  LOOPE shortlabel 	 K Also LOOPNZ:                                  

Loop if not equal(not zero):

Decrements CX and jumps to a short label 
if CX > 0 and the Zero flag is clear.

= L % K $ $ $ $ $ $ $ $ , $ $ $ $ $ $ $  LOOPNE shortlabel 	 L Move:                                 

Copies a byte of word from a source 
operand to a destination operand.










segreg,mem16 M % L $ $ $ $ $ $ $ $ ) 1 9 A K U b o  MOV reg,reg mem,reg reg,mem reg,immed mem,immed mem16,segreg reg16,segreg segreg,reg16 	# Also MOVSB, MOVSW :                       
Move string:                                 

Copies a byte or word from memory 
addressed by DS:SI to memory addressed 
by ES:DI.

MOVS requires both operands to be 
specified. MOVSB copies a byte, and 
MOVSW copies a word.

If the Direction flag is clear, SI and 
DI are incremented; otherwise, SI and DI 
are decremented.

MOVS dest,source
MOVS ES:dest,segreg:source
: # % # $ $ $ $ $ $ $ $ * $ $ $ $ $ $ $  MOVS see right 	$$ Unsigned integer multiply:                                 

Multiplies AL or AX by a source operand.

If the source is 8 bits, it is 
multiplied by AL and the product is 
stored in AX.

If the source is 16-bits, it is 
multiplied by AX and the product is 
stored in DX:AX

E $ % $ ) $ + - / 1 3 5 7 ; $ $ $ $ $ $  MUL * ? ? ? ? ? * reg mem 	 % Negate:                                 

Calculates the twos complement of the 
destination operand and stores the 
result in the destination.

C % % % ) $ $ + - / 1 3 5 9 $ $ $ $ $ $  NEG * * * * * * reg mem 	 & No operation:                                 

This instruction does nothing, but may 
be used inside a timing loop or to align 
a subsequent instruction on a word 
boundary.

7 & % & $ $ $ $ $ $ $ $ ) - $ $ $ $ $ $  NOP reg mem 	 ' Not:                                 

Performs a logical NOT on an operand by 
reversing each of its bits.

SEE ALSO
ANDe ' % ' $ $ $ $ $ $ $ $ ) 1 9 A K U $ $  NOT reg,reg mem,reg reg,mem reg,immed mem,immed acc,immed 	 ( Inclusive OR:                                 

Performs a logical OR on the destination 
operand, using the source.

If either bit is a 1 in each position, 
the result is a 1.

p ( % ( ( $ $ * , . 0 2 4 < D L V ` $ $  OR 0 * * ? * 0 reg,reg mem,reg reg,mem reg,immed mem,immed acc,immed 	 ) Output to port:                                 

Outputs a byte or word from the 
accumulator to a port. The port address 
may be a constant if in the range 0-FFh 
or DX may contain a port address between 
0 and FFFFh.

A ) % ) $ $ $ $ $ $ $ $ ) 4 $ $ $ $ $ $  OUT immed8,acc DX,acc 	 * Pop from stack:                                 

Copies a word at the current stack 
pointer location into the destination 
operand and adds 2 to SP.

B * % * $ $ $ $ $ $ $ $ ) / 5 $ $ $ $ $  POP reg16 mem16 segreg 	 + Push on stack:                                 

Subtracts 2 from SP and copies the 
source operand into the stack location 
pointed to by SP

C + % + $ $ $ $ $ $ $ $ * 0 6 $ $ $ $ $  PUSH reg16 mem16 segreg 	 , Push Flags:                                 

Subtracts 2 from SP and copies the flags 
register into the stack location pointed 
to by SP.

1 , % , $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  PUSHF 	1- Rotate carry left:                                 

Rotates the destination operand left. 
The Carry flag is copied into the lowest 
bit, and the highest bit is copied into 
the Carry flag. The constant 1 or the 
CL register may be used as a counter 
controlling the number of rotations.

M - % - ) $ $ $ $ $ $ + - 3 : @ $ $ $ $  RCL * * reg,1 reg,CL mem,1 mem,CL 	5. Rotate carry right:                                 

Rotates the destination operand right. 
The Carry flag is copied into the 
highest bit, and the lowest bit is 
copied into the Carry flag. The 
constant 1 or the CL register may be 
used as a counter controlling the number 
of rotations.

M . % . ) $ $ $ $ $ $ + - 3 : @ $ $ $ $  RCR * * reg,1 reg,CL mem,1 mem,CL 	 / Repeat string:                                 

Repeats a string primitive instruction, 
using CX as a counter. CX is decremented 
each time the instruction is repeated, 
until CX = 0.

8 / % / $ $ $ $ $ $ $ $ ) $ $ $ $ $ $ $  REP dest,src 	Q0 Conditional repeat string:                                 

Repeats a string primitive instruction 
until CX = 0 and while a flag condition 
is true.

REPZ (REPE) repeats while the Zero flag 
is set, and REPNZ (REPNE) repeats while 
the Zero flag is clear. Only the SCAS 
and CMPS instructions modify the Zero 
flag.

7 0 % 0 $ $ $ $ * $ $ $ , $ $ $ $ $ $ $  REPc * dest 	1 Also RETN, RETF:                                  

Return from procedure:

Pops a return address from the stack. 

RETN (return near) pops only the top of 
the stack into IP.

RETF (return far) first pops the stack 
into IP, and then into CS.

RET may be either near or far, depending 
on the attribute specified or implied by 
the PROC directive. An optional 8-bit 
immediate operand tells the CPU to add a 
value to SP after popping the return 
address.

6 1 % 1 $ $ $ $ $ $ $ $ ) $ $ $ $ $ $ $  RET immed8 	*2 Rotate left:                                 

Rotates the destination operand left. 
The highest bit is copied into the Carry 
flag and moved into the lowest bit 
position.

Either the constant 1 or the CL register 
may be used as a counter controlling the 
number of rotations.

M 2 % 2 ) $ $ $ $ $ $ + - 3 : @ $ $ $ $  ROL * * reg,1 reg,CL mem,1 mem,CL 	#3 Rotate right:                                 

Rotates the destination operand right.
The lowest bit is copied into both the 
Carry flag and the highest bit position.

Either the constant 1 or the CL register 
may be used as a counter controlling the 
number of rotations.

M 3 % 3 ) $ $ $ $ $ $ + - 3 : @ $ $ $ $  ROR * * reg,1 reg,CL mem,1 mem,CL 	 4 Store AH into flags:                                 

Copies AH into bits 0 through 7 of the 
Flags register.

The Trap, Interrupt, Direction, and 
Overflow flags are not affected.

: 4 % 4 $ $ $ * , . 0 2 $ $ $ $ $ $ $ $  SAHF * * * * * 	 5 Shift arithmetic left:                                 

Shifts each bit in the destination 
operand to the left. The highest bit is 
copied into the Carry flag, and the 
lowest bit is filled with a zero.

Identical to SHL.

U 5 % 5 ) $ $ + - / 1 3 5 ; B H $ $ $ $  SAL * * * ? * * reg,1 reg,CL mem,1 mem,CL 	?6 Shift arithmetic right:                                 

Shifts each bit in the destination 
operand to the right. The lowest bit is 
copied into the Carry flag, and the 
highest bit retains it previous value.

This shift is often used with signed 
operands, because it preserves the 
number's sign.

U 6 % 6 ) $ $ + - / 1 3 5 ; B H $ $ $ $  SAR * * * ? * * reg,1 reg,CL mem,1 mem,CL 	 7 Subtract with borrow:                                 

Subtracts the source operand from the 
destination operand and then subtracts 
the Carry flag from the destination.

q 7 % 7 ) $ $ + - / 1 3 5 = E M W a $ $  SBB * * * * * * reg,reg mem,reg reg,mem reg,immed mem,immed acc,immed 	$9 Shift left:                                 

Shifts each bit in the destination 
operand to the left. The highest bit is 
copied into the Carry flag, and the 
lowest bit is filled with a zero 
(identical to SAL).

Either a constant or CL may control the 
number of shifts.

T 9 % 9 ) $ $ + $ - 0 2 4 : A G $ $ $ $  SHL * * *? * * reg,1 reg,CL mem,1 mem,CL 	: Shift right:                                 

Shifts each bit in the destination 
operand to the right. The highest bit is 
filled with a zero, and the lowest bit 
is copied into the Carry flag. Either a 
constant or CL may control the number of 
shifts.

U : % : ) $ $ + - / 1 3 5 ; B H $ $ $ $  SHR * * * ? * * reg,1 reg,CL mem,1 mem,CL 	 ; Set Carry flag:                                 

Sets the Carry flag. This may be done by 
a procedure that want to signal an error 
condition to a calling program.

1 ; % ; $ $ $ $ $ $ $ ) $ $ $ $ $ $ $ $  STC 1 	 < Set Direction flag:                                 

Sets the Direction flag, causing SI 
and/or DI to be decremented by string 
primitive instructions.

Thus, string processing will be from 
high addresses to low addresses.

1 < % < $ ) $ $ $ $ $ $ $ $ $ $ $ $ $ $  STD 1 	= Set Interrupt flag:                                 

Sets the Interrupt flag, which enables 
maskable  interrupts.

Interrupts are automatically disabled 
when an interrupt occurs, so an 
interrupt handler procedure immediately 
reenables them, using STI.

1 = % = $ $ ) $ $ $ $ $ $ $ $ $ $ $ $ $  STI 1 	> Also STOSB, STOSW: Store string:                                 

Stores the accumulator in the memory 
location addressed by ES:DI.

If the Direction flag is clear, DI is 
increments; otherwise, DI is decremen- 
ted. If STOS is used, a destination 
operand must be specified.

STOSB stores the byte in AL into memory, 
and STOSW stores the word in AX into 
memory.

; > % > $ $ $ $ $ $ $ $ * . $ $ $ $ $ $  STOS mem ES:mem 	t ? Subtract:                                 

Subtracts the source operand from the 
destination operand.

q ? % ? ) $ $ + - / 1 3 5 = E M W a $ $  SUB * * * * * * reg,reg mem,reg reg,mem reg,immed mem,immed acc,immed 	 @ Test:                                 

Test individual bits in the destination 
operand against those in the source 
operand.

Performs a logical AND operation that 
affects the flags but not the destina- 
tion operand.

r @ % @ * $ $ , . 0 2 4 6 > F N X b $ $  TEST 0 * * ? * 0 reg,reg mem,reg reg,mem reg,immed mem,immed acc,immed 	 A Wait for coprocessor:                                 

Suspends CPU execution until the 
coprocessor finishes its current 
instruction.

0 A % A $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  WAIT 	t B Exchange:                                 

Exchanges the source operand with the 
destination operand.

f B % B $ $ $ $ $ $ $ $ * 2 : B L V $ $  XCHG reg,reg mem,reg reg,mem reg,immed mem,immed acc,immed 	9C Translate byte:                                 

Uses the value in AL to index into a 
table pointed to by DS:BX. The byte 
pointed to by the index is moved to AL. 
An operand may be specified in order to 
provide a segment override. Beginning 
with MASM 5.0 XLATB may be substituted 
for XLAT.

? C % C $ $ $ $ $ $ $ $ * . $ $ $ $ $ $  XLAT mem segreg,mem 	W SET SCREEN MODE                                 

INPUT AH=0
      AL=MODE

0   25X40 MONO
1   25X40 COLOR
2   25X80 MONO
3   25X80 COLOR
4   320X200 4-COLOR GRAPH
5   320X200 MONO GRAPH
6   640X200 MONO GRAHICS
7   25X80 MONO TEXT
13  320X200 COLOR GRAPH
14  640X200 16-COLOR GRAPH
15  640X350 MONO GRAPH
16  640X350 16-COLOR GRAPH
17  640X480 MONO GRAPH
18  640X480 VGA 16-COLOR GRAPH
19  320X200 VGA 256-COLOR GRAPH

 
5 W % W $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 10,00 	 Y SET CURSOR POSITION                                 

INPUT
DH,DL=ROW,COL
BH = PAGE NUMBER
AH = 2

NOTE: DH,DL =0,0 = UPPER LEFT

OUTPUT
CURSOR POSITION CHANGED

5 Y % Y $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 10,02 	! [ READ LIGHT PEN POSITION

5 [ % [ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 10,04 	 _ READ ATTRIB AND CHARACTER AT CURSOR 
POSITION

INPUT
BH=PAGE NUMBER
AH=8

OUTPUT

AL=CHAR READ(ASCII)
AH=ATTRIBUTE OF CHAR (ALPHNUMERICS ONLY)

5 _ % _ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 10,08 	 ` WRITE ATTRIBUTE AND CHARACTER AT CURSOR 
POSITON

INPUT

BH=PAGE NUMBER
BL: ALPHA MODES=ATTRIBUTE
  : GRAPHICS MODES = COLOR
CX=COUNT OF CHARACTERS TO WRITE
AL=IBM ASCII CODE
AH=9
5 ` % ` $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 10,09 	 a WRITE CHAR ONLY AT CURSOR POSITION

INPUT

BH=PAGE NUMBER
CX=COUNT OF CHARACTER TO WRITE
AL=IBM ASCII CODE
AH=0Ah

OUTPUT

CHARACTER WRITTEN ON SCREEN AT CURSOR 
POSITION

5 a % a $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 10,0A 	 g FUNCTION 0: SET PALETTE REGISTER

INPUT

AH=10h
AL=0
BL=PALETTE REGISTER (0-F)
BH=VALUE TO SET (0-63)

FUNCTION 1h:
...
FUNCTION 13h
5 g % g $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 10,10 	 Z FIND CURSOR POSITION                                 

INPUT
BH=PAGE NUMBER
AH=3

OUTPUT
DH,DL = ROW,COLUMN OF CURSOR
CH,CL = CURSOR MODE CURRENTLY SET.

5 Z % Z $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 10,03 	 \ SET ACTIVE DISPLAY PAGE                                 

INPUT

AL=0-7 (SCREEN MODES 0,1)
   0-3 (SCREEN MODES 2,3)
AH=5

OUTPUT

ACTIVE PAGE CHANGED


5 \ % \ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 10,05 	] SCROLL ACTIVE PAGE UP                                 

INPUT

AL=# LINES BLANKED AT BOTTOM (0=BLANK WHOLE AREA)
CH,CL=UPPER LEFT ROW,COLUMN OF AREA TO SCROLL.
DH,DL=LOWER RIGHT ROW,COL OF AREA TO SCROLL.
BH=ATTRIBUTE USED ON BLANK LINE
AH=6
5 ] % ] $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 10,06 	 ^ SCROLL ACTIVE PAGE DOWN                                 

AL=# LINES BLANKED AT BOTTOM (0=BLANK WHOLE AREA)
CH,CL=UPPER LEFT ROW,COLUMN OF AREA TO SCROLL.
DH,DL=LOWER RIGHT ROW,COL OF AREA TO SCROLL.
BH=ATTRIBUTE USED ON BLANK LINE
AH=7
5 ^ % ^ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 10,07 	 b SET COLOR PALETTE                                 

INPUT
BH=PALETTE COLOR ID
BL  BH=0 ->BL=BACKGROUND COLOR
    BH=1 ->BL=Palette NUMBER
           (0=GREEN/RED/YELLOW)
           (1=CYAN/MAGENTA/WHITE)

AL=0B
5 b % b $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 10,0B 	c WRITE DOT                                 

INPUT

DX=ROW NUMBER(0-199) (0,0=UPPER LEFT)
CX=COLUMN NUMBER(0-319,639)
AL=COLOR VALUE (0-3)
AH=0C (12)

NOTE: IF BIT 7 OF AL IS ON, THE COLOR 
VALUE IS XORED WITH THE CURRENT VALUE 
OF THE DOT.
5 c % c $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 10,0C 	
d READ DOT                                 

INPUT

DX=ROW NUMBER(0-199) (0,0=UPPER LEFT)
CX=COLUMN NUMBER(0-319,639)
AH=0D (13)

OUTPUT

AL=COLOR VALUE (0-3)

NOTE: IF BIT 7 OF AL IS ON, THE COLOR 
VALUE IS XORED WITH THE CURRENT VALUE 
OF THE DOT.
5 d % d $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 10,0D 	 e TELETYPE WRITE TO ACTIVE PAGE                                 

INPUT

AL=IBM ASCII CODE
BL=FOREGROUND COLOR (GRAPHICS MODE)
AH=0E (14)
5 e % e $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 10,0E 	 f RETURN VIDEO STATE                                 

INPUT

AH=OF(15)

OUTPUT

AH=NUMBER OF COLUMNS ON SCREEN
AL=CURRENT MODE (SEE SERVICE 0)
BH=ACTIVE PAGE
5 f % f $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 10,0F 	j EQUIPMENT CHECK                                 

OUTPUT

BITS OF AX

15,14 = NUMBER OF PRINTERS
13      NOT USED
12      GAME ADAPTER ATTACHED
11,10,9 NUMBER OF RS232 CARDS INSTALLED
8       UNUSED
7,6     NUMBER OF DISK DRIVES
        (00=1;01=2;10=3;11=4)
5,4     VIDEO MODE
        (00 UNUSED;01=40X25COLOR CARD;
         10=80X25 COLOR; 11=80X25 MONO)
3,2     MOTHERBOARD RAM
        (00=16K;01=32K;10=48K;11=64K)
1       NOT USED
0       1 IF  THERE ARE DISK DRIVES ATTACHED
2 j % j $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 11 	r k DETERMINE MEMORY SIZE                    

AH=0

OUTPUT

AX= NUMBER OF CONTIGUOUS 1K MEMORY BLOCKS

2 k % k $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 12 	 i ALTERNATE SELECT                                 

INPUT

AH=12h
BL=30h
AL=0->200 SCREEN SCAN LINES
   1->350 SCREEN SCAN LINES
   2->400 SCREEN SCAN LINES
5 i % i $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 10,12 	 s TIMER TICK INTERRUPT
2 s % s $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 1C 	 t VIDEO PARAMETER TABLES
2 t % t $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 1D 	 u DISK PARAMETERS

2 u % u $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT IE 	& v GRAPHICS CHARACTER DEFINITIONS
2 v % v $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 1F 	  CLEAR KBD BUFFER AND INVOKE SERVICE

INPUT
AH=0C
AL=KEYBOARD FUNCTION#

OUTPUT
STANDARD OUTPUT FROM THE SELECTED 
SERVICE.

5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,0C 	v l READ KEY FROM KEYBOARD                                 

INPUT
AH=1

OUTPUT
AH=SCANCODE
AL=ASCII CODE

5 l % l $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 16,00 	r n FIND KEYBOARD STATUS                                 

INTPUT
AH=2

OUTPUT
AL=KEYBOARD STATUS BYTE

5 n % n $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 16,02 	g o BOOTSTRAP                                 

THIS INTERRUPT IS THE ONE THAT
BOOTS THE MACHINE
2 o % o $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 19 	 p READ TIME OF DAY                                 

INPUT
AH=0

OUTPUT
CX=HIGH WORD OF TIMER COUNT
DX=LOW WORD OF TIMER COUNT
AL=0 IF TIMER HAS NOT PASSED 24
     HOURS SINCE LAST READ.

NOTE: TIMER COUNT INCREASES BY
65,536 IN ONE HOUR.
5 p % p $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 1A,00 	 q SET TIME OF DAY                                 

INPUT
AH=1
CX=HIGH WORD OF TIMER COUNT
DX=LOW WORD OF TIMER COUNT

NOTE: TIMER COUNT INCREASES BY
65,536 IN ONE HOUR.
5 q % q $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 1A,01 	? r KEYBOARD BREAK ADDRESS                                 
2 r % r $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 1B 	` w TERMINATE                                 

PROGRAMS SOMETIMES END WITH INT 20
INT 20
2 w % w $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 20 	V x TERMINATE                                 

PROGRAM TERMINATE

INPUT
AH=0
5 x % x $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,00 	 y KEYBOARD INPUT                                 

INPUT
AH=1

OUTPUT
AL=ASCII CODE OF STRUCK KEY ECHOS ON 
     SCREEN.

THIS SERVICE CHECKS FOR ^C OR ^BREAK
5 y % y $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,01 	j z CHARACTER OUTPUT TO SCREEN                                 

INPUT
DL=IBM ASCII CHARACTER
AH=2
5 z % z $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,02 	k | STANDARD AUXILIARY DEVICE OUTPUT                                 

INPUT
AH=4
DL=CHAR TO OUTPUT
5 | % | $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,04 	[ } PRINTER OUTPUT                                 

INPUT
AH=5
DL=CHAR TO OUTPUT

5 } % } $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,05 	 ~ CONSOLE I/O                                 

INPUT    OUTPUT
AH=6
DL=FF -> AL HOLDS CHAR,IF ONE READY
DL<FF -> TYPE ASCII CODE IN DL OUT.
         DOES NOT ECHO ON SCREEN.

THIS SERVICE DOES NOT CHECK FOR ^C NOR 
^BREAK
5 ~ % ~ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,06 	  CONSOLE INPUT WITHOUT ECHO                                 

INPUT
AH=7

OUTPUT
AL=ASCII CODE OF STRUCK KEY
NO ECHO ON SCREEN

THIS SERVICE DOES NOT CHECK FOR ^C NOR 
^BREAK
5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,07 	p  STRING PRINT                                 

INPUT
DS:DX POINT TO A STRING THAT ENDS IN '$'
AH=9

5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,09 	  STRING INPUT                                 

INPUT
AH=0A
[DS:DX]=LENGTH OF BUFFER

OUTPUT
BUFFER AT DS:DX FILLED
ECHO THE TYPED KEYS

THIS SERVICE DOES CHECK FOR ^C NOR 
^BREAK
5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,0A 	  CHECK INPUT STATUS                                 

INPUT
AH=0B

OUTPUT
AL=FF -> CHARACTER READY
AL=00 -> NOTHING TO READ IN

^BREAK IS CHECKED FOR

5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,0B y  
 
    INTERRUPTS set ems                      
&	
                     INT (Instr#"INT") 	2 h CHARACTER GENERATOR???????????????????????
5 h % h $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 10,11 	U { STANDARD AUXILIARY DEVICE INPUT         

INPUT
AH=3

OUTPUT
CHAR IN AL
5 { % { $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,03 	E  DISK RESET                               

INPUT

AH=0D

5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,0D 	  OPEN PREEXISTING FILE                  

INPUT

DS:DX POINT TO AN FCB
AH=0F

OUTPUT

AL=0->SUCCESS
AL=1->FAILURE

5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,0F 	s  SELECT DISK                              

INPUT

AH=0E
DL=DRIVE NUMBER
     (DL=0->A,DL=1->B,ETC.)

5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,0E 	  CLOSE FILE                             

INPUT

DS:DX POINT TO AN FCB
AH=10

OUTPUT

AL=0->SUCCESS
AL=1->FAILURE

5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,10 	  SEARCH FOR FIRST MATCHING FILE             

INPUT

DS:DX POINTS TO AN UNOPENED FILE
AH=11h

OUTPUT

AL=FF->FAILURE
AL=00->SUCCESS : DTA HOLDS FCB FOR MATCH

NOTEA: DTA IS AT CS:0080 IN .COM FILES ON 
STARTUP.

5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,11 	  SEARCH FOR NEXT MATCHING FILE              

INPUT

DS:DX POINTS TO AN UNOPENED FCB
AH=12h

OUTPUT

AL=FF->FAILURE
AL=00->SUCCESS: DTA HOLDS FCB FOR MATCH

(USE ONLY AFTER SERVICE 11h)

5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,12 	  DELETE FILES                              

INPUT

DS:DX POINTES TO AND UNOPENED FCB
AH=13

OUTPUT

AL=FF->FAILURE
AL=00->SUCCESS

5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,13 	Z SEQUENTIAL READ                         

INPUT

DS:DX POINTS TO AN OPENED FCB
AH=14
CURRENT BLOCK AND RECORD SET IN FCB

OUTPUT

REQUESTED RECORD PUT IN DTA
AL=0 -> SUCCESS
   1 END OF FILE, NO DATA IN RECORD
   2 DTA SEGMENT TOO SMALL FOR RECORD
   3. END OF FILE; RECORD PADDED WITH 0

NOTE: RECORD ADDRESS INCREASED.

5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,14 	 SEQUENTIAL WRITE                        

DS:DX POINTS TO AN OPENED FCB
AH=15
CURRENT BLOCK AND RECORD SET IN FCB

OUTPUT

ONE RECORD READ FROM DTA AND WRITTEN
AL=0 -> SUCCESS
   1 DISK FULL
   2 DTA SEGMENT TOO SMALL FOR RECORD

NOTE: RECORD ADDRESS INCREASED.

5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,15 	  CREATE FILE                              

INPUT

DS:DX POINTS TO AN unOPENED FCB
AH=16h

OUTPUT

AL=0 SUCCESS
AL=FF DIRECTORY FULL

5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,16 	1  INTERNAL TO DOS                        

5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,18 	p  FIND CURRENT DISK                      

INPUT

AH=19

OUTPUT

AL=CURRENT DISK # (0=A;1=B,ETC)

5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,19 	  SET THE DTA LOCATION                    

INPUT

DS:DX POINTS TO NEW DTA ADDRESS
AH=1A

NOTE: DTA=DISK TRANSFER ADDRESS, THE DATA 
ARE USED WITH FCB SERVICES. DEFAULT DTA IS 
128 BYTES LONG, STARTING AT CS:0080 IN THE 
PSP.

5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,1A 	 FAT INFORMATION FOR DEFAULT DRIVE       

INPUT

AH=1B

OUTPUT

DS:bX POINT TO THE "FAT BYTE"
DX = NUMBER OF CLUSTERS
AL = NUMBER OF SECTORS/CLUSTER
CX = SIZE OF A SECTOR (512 BYTES)

NOTE: FILES ARE STORED IN CLUSTERS, THE 
SMALLEST ALLOCATABLE UNIT ON A DISK.

5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,1B 	/ FAT INFORMATION FOR SPECIFIED DRIVE     

INPUT

AH=1B
DL=DRIVE NUMBER 

OUTPUT

DS:bX POINT TO THE "FAT BYTE"
DX = NUMBER OF CLUSTERS
AL = NUMBER OF SECTORS/CLUSTER
CX = SIZE OF A SECTOR (512 BYTES)

NOTE: FILES ARE STORED IN CLUSTERS, THE 
SMALLEST ALLOCATABLE UNIT ON A DISK.

5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,1C 	2  SERVICES 1D-20 ARE INTERNAL TO DOS      

6  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,1D  	  RANDOM WRITE                            

INPUT

DS:DX POINTS TO AN OPENED FCB
SET FCB'S RANDOM RECORD FIELD AT DS:SX + 33 
AND DS:DX + 35
AH=22

OUTPUT

AL=00 SUCCESS
   01 DISK IS FULL
   02 NOT ENOUGH SPACE IN DTA SEGMENT

5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,22 	  FILE SIZE                                

INPUT

DS:DX POINTS TO AN UNOPENED FCB
AH=23

OUTPUT
AL = 00 SUCCESS
     FF NO FILE FOUND THAT MATCH FCB
     RANDOM RECORD FIELD SET TO THE FILE 
     LENGTH IN RECORDS,ROUNDED UP.

5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,23 	  SET RANDOM RECORD FIELD                 

INPUT

DS:DX POINTS TO AN OPENED FCB
AH=24

OUTPUT

RANDOM RECORD FIELD SET TO MATCH CURRENT
RECORD AND CURRENT BLOCK.

5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,24 	< RANDOM READ                             

INPUT

DS:DX POINTS TO AN OPENED FCB
SET FCB'S RANDOM RECORD FIELD AT DS:SX+33 
AND DS:DX + 35
AH=21

OUTPUT

AL=00 SUCCESS
   01 END OF FILE, NO MORE DATA
   02 NOT ENOUGH SPACE IN DTA SEGMENT
   03 END OF FILE, PARTIAL RECORD PADDED 
      WITH 0s

5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,21 	  RENAME FILE                             

INPUT

DS:DX POINTS TO A modified FCB
AH=17

OUTPUT

AL=00 SUCCESS
AL=FF FAILURE


NOTE:MODIFIED FCB->SECOND FILE NAME STARTS 
6 BYTES AFTER THE END OF THE FIRST FILE 
NAME, AT DS:DX+11h

5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,17 	  SET INTERRUPT VECTOR                   

INPUT

AH=25
AL=INTERRUPT NUMBER
DS:DX=NEW ADDRESS

NOTE: THIS SERVICE CAN HELP YOU INTERCEPT 
AN INTERRUPT VECTOR
5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,25 	E  CREATE A NEW PROGRAM SEGMENT             

INPUT

AH=26

5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,26 	 RANDOM BLOCK READ                        

INPUT

DS:DX POINTS TO AN OPENED FCB
SET FCB's RANDOM RECORD FIELD AT DS:DX+33 
AND DS:DX+35
AH=27

OUTPUT

AL=00 SUCCESS
   01 ENDOF FILE; NO MORE DATA
   02 NOT ENOUGH SPACE IN DTA SEGMENT
   03 END OF FILE,PARTIAL RECORD PADDED 
   WITH 0's
CX=NUMBER OF RECORDS READ
RANDOM RECORD FIELDS SET TO ACCESS NEXT 
RECORD.

NOTE:THE DATA BUFFER USED IN FCB SERVICES 
IS THE DTA, (DISK TRANSFER AREA).
5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,27 	 RANDOM BLOCK WRITE                     

INPUT

DS:DX POINTS TO AN OPENED FCB
SET FCB's RANDOM RECORD FIELD AT DS:DX+33 
AND DS:DX+35
AH=28

OUTPUT

AL=00 SUCCESS
   01 DISK IS FULL
   02 NOT ENOUGH SPACE IN DTA SEGMENT
CX=0 FILE SET TO THE SIZE INDICATED BY THE 
RANDOM RECORD FIELD.

NOTE:THE DATA BUFFER USED IN FCB SERVICES 
IS THE DTA, (DISK TRANSFER AREA).

5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,28 	  GET DATE                                

INPUT

AH=2Ah

OUTPUT

CX = YEAR-1980
DH = MONTH(1=JAN,ETC)
DL = DAY OF THE MONTH

5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,2A 	  SET DATE                                

INPUT

CX = YEAR-1980
DH = MONTH(1=JAN,ETC)
DL = DAY OF MONTH
AH = 2Bh

OUTPUT

AL = 0 SUCCESS
AL = FF DATE NOT VALID
5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,2B 	  GET TIME                                

INPUT

AH=2C

OUTPUT

CH=HOURS(0-23)
CL=MINUTES(0-59)
DH=SECONDS(0-59)
DL=HUNDRETHS OF SECONDS(0-99)

5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,2C 	  SET TIME                                

INPUT

AH=2D
CH=HOURS(0-23)
CL=MINUTES(0-59)
DH=SECONDS(0-59)
DL=HUNDRETHS OF SECONDS(0-99)

OUTPUT

AL=0 SUCCESS
AL=FF TIME IS INVALID
5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,2D 	u  SET OR RESET VERIFY SWITCH              

INPUT

AH=2E
DL=0
AL=1->TURN VERIFY ON
  =0->TURN VERIFY OFF
5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,2E 	  GET CURRENT DTA                         

INPUT

AH=2F

OUTPUT

ES:BX=CURRENT DTA ADDRESS

NOTE: THE  DATA BUFFER USED IN FCB SERVICES 
IS THE DTA, OR DISK TRANSFER AREA

5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,2F 	  GET DOS VERSION NUMBER                  

INPUT

AH=30

OUTPUT

AL=MAJOR VERSION NUMBER (3 IN DOS 3.1)
AH=MINOR VERSION NUMBER (10 IN DOS 3.10)

BX=0
CX=0

NOTE:IF AL RETURNS 0, YOUR ARE WORKING WITH 
A VERSION OF DOS BEFORE 2.0

5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,30 		 TERMINATE PROCESS AND KEEP RESIDENT     

INPUT

AH=31
AL=BINARY EXIT CODE
DX=SIZE OF MEMORY REQUEST IN PARAGRAPHS

NOTE EXIT CODE CAN BE READ BY A PARENT 
PROGRAM WITH SERVICE 4Dh. IT CAN ALSO BE 
TESTED BY ERRORLEVEL COMMANDS IN BATCH 
FILES.

5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,31 	2  INTERNAL TO DOS                         

5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,32 	  CONTROL-BREAK CHECK                     

INPUT

AH=33
AL=0->CHECK STATE OF ^BREAK CHECKING
  =1->SET THE STATE OF ^BREAK CHECKING
      (DL=0->TURN IT OFF; DL=1->TURN IT ON)

OUTPUT

DL=0->OFF
DL=1->ON

5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,33 	.  INTERNAL TO DOS                         5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,34 	 m CHECK IF KEY READY TO BE READ                                 

INPUT
AH=1

OUTPUT
ZERO FLAG=1,BUFFER EMPTY
ZERO FLAG=0,->AH=SCAN CODE
              AL=ASCII CODE
5 m % m $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 16,01 	OD Exclusive OR:                                 

Each bit in the source operand is 
exclusive ORed with its corresponding bit 
in the destination. The destination bit 
is a 1 only when the original and desti- 
nation bits are different.

HERE'S A C++ VERSION OF HOW TO TOGGLE 
UPPER & LOWER CASE WITH XOR 32

#include <iostream.h>
#include <string.h>
#include <ctype.h>

void main()
{
	char str[80];
	int i,s;

	cin.getline(str,sizeof(str)-1,'\n');
	cout << '\n' << str;

	s=strlen(str);

	for (i=0;i<s;i++) if(str[i]!=' ') str[i]^=32;
	cout << '\n' << str;
}q D % D ) $ $ + - / 1 3 5 = E M W a $ $  XOR 0 * * ? * 0 reg,reg mem,reg reg,mem reg,immed mem,immed acc,immed 	  CONSOLE INPUT WITHOUT ECHO WITH ^C CHECK

INPUT
AH=8

OUTPUT
AL=ASCII CODE OF STRUCK KEY
NO ECHO ON SCREEN

THIS SERVICE DOES CHECK FOR ^C OR 
^BREAK
5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,08 	% PARSE FILE NAME                         

INPUT

DS:SI = COMMAND LINE TO PARSE
ES:DI = ADDRESS TO PUT FCB AT
AL = BIT 0 = 1 -> LEADING SEPARATORS ARE
                  SCANNED OFF COMMAND LINE
     BIT 1 = 1 -> DRIVE ID IN FINAL FCB 
                  WILL BE CHANGED only if A 
                  DRIVE WAS SPECIFIED
     BIT 2 = 1 -> FILE NAME IN FCB CHANGED 
                  only if COMMAND LINE 
                  INCLUDES FILE NAME
     BIT 3 = 1 -> FILE NAME EXTENSION IN 
                  FCB WILL BE CHANGED ONLY 
                  IF COMMAND LINE CONTAINS 
                  A FILE NAME SUCCESSION.
AH=29h

OUTPUT

DS:SI=FIRST CHARACTER AFTER FILE NAME.
ES:DI=VALID FCB

NOTE:IF THE COMMAND LINE DOES NOT CONTAIN A 
VALID FILE NAME, ES[DI+1] WILL BE A BLANK.

5  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  INT 21,29 	 Conditional jump:                                 

Jumps to a label if a specified flag 
condition is true. The label must be in 
the range of -128 to +127 bytes from the 
next instruction.

Special format:

Jcondition shortlabel

Available mnemonics:

JA   jump if above
JNA  jump if not above
JAE  jump if above or equal
JNAE jump if not above or equal
JB   jump if below
JNB  jump if not below
JBE  jump if below or equal
JNBE jump if not below or equal
JG   jump if greater
JNG  jump if not greater
JGE  jump if greater or equal
JNGE jump if not greater or equal
JL   jump if less
JNL  jump if not less
JLE  jump if less or equal
JNLE jump if not less or equal
JE   jump if equal
JNE  jump if not equal
JZ   jump if zero
JNZ  jump if not zero
JS   jump if sign
JNS  jump if not sign
JC   jump if carry
JNC  jump if no carry
JO   jump if overflow
JNO  jump if not overflow
JP   jump if parity
JPE  jump if parity equal
JNP  jump if no parity
JPO  jump if parity odd


0  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  Jcon 	P FLAGS:                                 

1 = sets the flag
0 = clears the flag
? = may change the flag to an undetermined
    value
()= flag is unchenged
* = changes the flag according to specific
    rules associated with the flag

INSTRUCTIONS:

reg  an 8-bit or 16-bit general purpose 
     register (AX,BX,CX,DX,AH,AL,BH,BL,
     CH,CL,SI,DI,BP,SP)

segreg  a 16-bit segment register (CS,
        DS,ES,SS)

accum   AX or AL

mem     a memory operand, using any of 
        the standard memory addressing
        modes.

shortlabel
        a label within -128 to +127 
        bytes from the next instruction.

nearlabel
        a label in the current code 
        segment.

farlabel
        a label in another code segment

source  the source operand

dest    the destination operand, that 
        is, the one that will be changed 
        by the instruction.

immed   an immediate operand

instruction
        an 8086/88 assembly language 
        command. 

MOST MATERIAL FROM KIP IRVINE, ASSEMBLY
LANGUAGE FOR THE IBM-PC, MACMILLAN, 1990
0  %  $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $  1KEY 5     Unnamed Smart Clip              
@o    	y O All Fields                      Instr: 
@o   	
Des: 
@o  	
Flags: 
Ovfl: 
@o  	
Dirn: 
@o  	
Intr: 
@o  	
Sign: 
@o  	
Zero: 
@o  	
AuxC: 
@o  	
Prty: 
@o 	 	
Cary: 
@o 
 	
Fmts: 
A: 
@o  	
B: 
@o 
 	
C: 
@o  	
D: 
@o  	
E: 
@o  	
F: 
@o  	
G: 
@o  	
H: 
@o  	
	)8 Also SCASB, SCASW: Scan string:                                 

Scans a string in memory pointed to by 
ES:DI for a value that matches the 
accumulator. SCAS requires the operands 
to be specified.

SCASB scans for a value matching AL, and 
SCASW scans for a value matching AX.

I 8 % 8 * $ $ , . 0 2 4 6 ; $ $ $ $ $ $  SCAS * * * * * * dest ES:dest       
       ݮ   ?          T  +         ) J          : J          L J          ] J          n J           J           J           J         V  z           Z * r         Z ; r         Z L r         Z ^ r         Z p r         Z  r         Z  r         Z  r               &Instr   
     &Des        &Flags        Ovfl        Dirn        Intr    
    Sign        Zero        AuxC  	      Prty  
      Cary        F&mts        A  
      B        C        D        E        F         G    "    H I     DataCard                        
@o   	
=

@o  	

	R ASCII adjust after multiply                                 

Adjusts the results in AX after two 
unpacked BCD digits have been multiplied
together.

SAMPLE CODE

MOV AX,004C; AX=76 DEC
AAM        ; NOW = 0706h
OR AX,3030 ; NOW = 3736h

Doesn't have to be used only after 
multiplication.

Reverses what aad does.
 <  %  ) $ $ , . 0 2 4 $ $ $ $ $ $ $ $  AAM ?? * * ? * ? b         All Database Items                      
&	
                    	}  Logical AND:                                 

ANDs the bits in the destination operand
with the source operand.

q  %  ) $ $ + - / 1 3 5 = E M W a $ $  AND * * * ? * 0 reg,reg mem,reg reg,mem reg,immed mem,immed acc,immed 	  Compare:                                 

Compares the destination to the source 
by performing an implied subtraction of 
the source from the destination.




q  %  ) $ $ + - / 1 3 5 = E M W a $ $  CMP * * * * * * reg,reg mem,reg reg,mem reg,immed mem,immed acc,immed 
   E N O P Q R S T U V W X Y Z [ \ ] ^ _ ` a b c d e f g h i j k l m n o p q r s t v w x y z { | } ~                                            u  
Z            	 
   
               E N O P Q R S T U V W X Y Z [ \ ] ^ _ ` a b c d e f g h i j k l m n o p q r s t v w x y z { | } ~                                            u       ! " F G H I J K L M # $ % & ' ( ) * + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < = > ? @ A B C D         ۶   q               ϸ               )   ;   N   ]   l   {             b   y  ~ u   l  i R  o 	   ~
 P ; }   |  H  \        t   _     ,             J  $ 4           "   # Y c$   %   '     '    )   *   *  U4 $ D6   7   8   9   l:   ;   <   =   > 1 V? 5 @   VB Q VC  D * F # nH   I   J ? "L   M ) i $ N  XP   Q   R  S  U t  V   W   Y t  Y 9 Z O    +   ,  _- r .   Z0   r1   Q2   :3     W      n   + 3   7  u 1     C W   1    #\      ^   b !  _   c  d   e   Y_   0`   *a   g  (h 
 _i   j   kk   b 2  V   o  Nl r  {n v  r   / r  r g  Ss   s   !u ?  
v   o   Mp   p &  p `  ~v V  w   w j  }x U   k  y [  y   Lz   n{   ֦ p  b|   }   ~   @q E  G s  z      "   ۂ       Z Ņ  T      s 1  q p  ׉   |   /  2  Z <              E       	 %    ę      p   H u  C       	  2  P    .  ̢ Z Ҿ    ;  . q  

 ;  	 <  a ;  1 q  M 0   q  | S  : /   1  ` 1  C 1  . 1   q   F   /   ;   ;   A  f C   C  X /  b D  q  D  @" ?  ]# A  "$ =  % 4  & @  ' 0   ;  ( _  ) 0  * 9  + :  
6 E  h7 C  J8 7  K9 e  : p  ,; A  < B  l= C  I> 1  %? M  @ M  	B 8  C 7  D 6  F M  !H M  I :  J U  K U  aM q  oN I   T  P U  hQ 1  pR 1  S 1  T ;  V q  :W r  X 0  Y f  EZ ?  [ q  e 2    7  T, 9  &- <  m. ?  0 ;  71 <  2 =  2   3 2  < 2   2   2  C 2   4   2   2  Q 2   5  ] 5   5  ^ 5  c 5  $_ 5  vd 5  e 5  f 5  _ 5  ` 5  a 5  g 5  *i 5  lj 5  6k 5  l 5  b 5   5  o 2  In 2  n 5  wr 5   5  s 2  s 5  t 5  u 2  Lv 2  p 2  kp 2  p 2  q 2  v 5  fw 5  Hx 5  x 5   5  y 5  z 5  9{ 5  -| 5  } 5  | 5  } 5  ~ 5  q 5   5   5  E 5   5  Ã 5  Ƅ 5   5   5  p 5  < 5  p 5   5  G 5  o 5   5  % 6   5  > 5   5   5  ͑ 5  Q 5  ˕ 5  ԗ 5   5  ת 5  S 5  ; 5   5   5   5   5  ݟ 5   5   5   5   I  ƹ y  5                nqqqqqqqqqqqqqqqqqqq